local c;
local player = Var "Player";
local ShowComboAt = THEME:GetMetric("Combo", "ShowComboAt");
local Pulse = THEME:GetMetric("Combo", "PulseCommand");

local NumberMinZoom = THEME:GetMetric("Combo", "NumberMinZoom");
local NumberMaxZoom = THEME:GetMetric("Combo", "NumberMaxZoom");
local NumberMaxZoomAt = THEME:GetMetric("Combo", "NumberMaxZoomAt");

local AchieveShowCommand = cmd(animate,true;loop,false;blend,"BlendMode_Add";y,-170;diffusealpha,1;sleep,1;linear,0.5;diffusealpha,0;);

local t = Def.ActorFrame {
	LoadFont( "Combo", "ComboNumber" ) .. {
		Name="ComboNumber";
		OnCommand = THEME:GetMetric("Combo", "ComboNumberOnCommand");
	};
	LoadActor("_combo") .. {
		Name="ComboLabel";
		OnCommand = THEME:GetMetric("Combo", "ComboLabelOnCommand");
	};
	-- achieve thingies
	Def.Sprite{
	--LoadActor("achieve-good")..{
		Name="AchieveGood";
		InitCommand=cmd(diffusealpha,0;y,-94;animate,false;loop,false);
		ShowCommand=AchieveShowCommand;
		ResetCommand=cmd(diffusealpha,0;animate,false;loop,false;setstate,0);
		-- sprite part
		Texture=THEME:GetPathG("Player","Combo/achieve-good");
		Frame0000=0;
		Delay0000=0.05;
		Frame0001=1;
		Delay0001=0.05;
		Frame0002=2;
		Delay0002=0.05;
		Frame0003=3;
		Delay0003=0.05;
		Frame0004=4;
		Delay0004=0.05;
		Frame0005=5;
		Delay0005=0.05;
		Frame0006=6;
		Delay0006=0.05;
		Frame0007=7;
		Delay0007=0.05;
		Frame0008=8;
		Delay0008=0.05;
		Frame0009=9;
		Delay0009=0.05;
		Frame0010=10;
		Delay0010=0.05;
		Frame0011=10.05;
		Delay0011=0.05;
		Frame0012=12;
		Delay0012=0.05;
		Frame0013=13;
		Delay0013=0.05;
		Frame0014=14;
		Delay0014=0.05;
	};
	LoadActor( "achieve-great" ) .. {
		Name="AchieveGreat";
		InitCommand=cmd(diffusealpha,0;y,-94);
		ShowCommand=AchieveShowCommand;
	};

	InitCommand = function(self)
		c = self:GetChildren();
		c.ComboNumber:visible(false);
		c.ComboLabel:visible(false);
	end;

	ComboCommand=function(self, param)
		local iNum = param.Misses or param.Combo;
		local isCombo = (param.Combo) and true or false;

		c.ComboNumber:visible(false);
		c.ComboLabel:visible(false);

		local ShowAt;
		if param.Combo then
			ShowAt = ShowComboAt;
		else
			ShowAt = -1;
		end
		
		if not iNum  or  ShowAt == -1  or  iNum < ShowAt then
			return;
		end

		local Number;
		if param.Combo then
			Number = c.ComboNumber;
		end

		local Label = c.ComboLabel;

		local achieve = nil;
		if (iNum % 10 == 0) and isCombo then
			achieve = c.AchieveGood;
		elseif (iNum == 50) and isCombo then
			achieve = c.AchieveGreat;
		end;

		param.Zoom = scale( iNum, 0, NumberMaxZoomAt, NumberMinZoom, NumberMaxZoom );
		param.Zoom = clamp( param.Zoom, NumberMinZoom, NumberMaxZoom );

		Number:visible(true);
		Label:visible(true);

		Number:settext( string.format("%i", iNum) );

		Pulse( Number, param );
		Pulse( Label, param );

		if achieve ~= nil then
			achieve:playcommand("Show");
		end
	end;
};

return t;
